% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom-scaling.R
\name{bed_MAF}
\alias{bed_MAF}
\title{Allele frequencies}
\usage{
bed_MAF(
  obj.bed,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  ncores = 1
)
}
\arguments{
\item{obj.bed}{Object of type \link{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}.}
}
\value{
A data.frame with
\itemize{
\item \verb{$ac}: allele counts,
\item \verb{$mac}: minor allele counts,
\item \verb{$af}: allele frequencies,
\item \verb{$maf}: minor allele frequencies,
\item \verb{$N}: numbers of non-missing values.
}
}
\description{
Allele frequencies of a \link{bed} object.
}
\examples{
bedfile <- system.file("extdata", "example-missing.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

bed_MAF(obj.bed, ind.col = 1:5)

}
