% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvarx.R
\name{sparseVARX}
\alias{sparseVARX}
\title{Sparse Estimation of the Vector AutoRegressive  with Exogenous Variables X (VARX) Model}
\usage{
sparseVARX(
  Y,
  X,
  p = NULL,
  s = NULL,
  VARXpen = "HLag",
  VARXlPhiseq = NULL,
  VARXPhigran = NULL,
  VARXlBseq = NULL,
  VARXBgran = NULL,
  VARXalpha = 0,
  h = 1,
  cvcut = 0.9,
  eps = 10^-3,
  selection = c("none", "cv", "bic", "aic", "hq"),
  check_std = TRUE
)
}
\arguments{
\item{Y}{A \eqn{T} by \eqn{k} matrix of time series. If k=1, a univariate autoregressive model is estimated.}

\item{X}{A \eqn{T} by \eqn{m} matrix of time series.}

\item{p}{User-specified maximum endogenous autoregressive lag order. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{s}{User-specified maximum exogenous autoregressive lag order. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARXpen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization in VARX.}

\item{VARXlPhiseq}{User-specified grid of values for regularization parameter corresponding to the endogenous autoregressive coefficients in the VARX. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARXPhigran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the endogenous autoregressive coefficients in the VARX:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARXlBseq}{User-specified grid of values for regularization parameter corresponding to the exogenous autoregressive coefficients in the VARX. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARXBgran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the exogenous autoregressive coefficients in the VARX:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARXalpha}{a small positive regularization parameter value corresponding to squared Frobenius penalty. The default is zero.}

\item{h}{Desired forecast horizon in time-series cross-validation procedure.}

\item{cvcut}{Proportion of observations used for model estimation in the time series cross-validation procedure. The remainder is used for forecast evaluation.}

\item{eps}{a small positive numeric value giving the tolerance for convergence in the proximal gradient algorithm.}

\item{selection}{Model selection method to be used. Default is none, which will return all values for all penalisations.}

\item{check_std}{Check whether data is standardised. Default is TRUE and is not recommended to be changed}
}
\value{
A list with the following components
\item{Y}{\eqn{T} by \eqn{k} matrix of endogenous time series.}
\item{X}{\eqn{T} by \eqn{m} matrix of exogenous time series.}
\item{k}{Number of endogenous time series.}
\item{m}{Number of exogenous time series.}
\item{p}{Maximum endogenous autoregressive lag order of the VARX.}
\item{s}{Maximum exogenouss autoregressive lag order of the VARX.}
\item{Phihat}{Matrix of estimated endogenous autoregressive coefficients.}
\item{Bhat}{Matrix of estimated exogenous autoregressive coefficients.}
\item{phi0hat}{vector of VARX intercepts.}
\item{exogenous_series_names}{names of the exogenous time series}
\item{endogenous_series_names}{names of the endogenous time series}
\item{lambdaPhi}{sparsity parameter grid corresponding to endogenous autoregressive parameters}
\item{lambdaB}{sparsity parameter grid corresponding to exogenous autoregressive parameters}
\item{lambdaPhi_opt}{Optimal value of the sparsity parameter (corresponding to the endogenous autoregressive parameters) as selected by the time-series cross-validation procedure}
\item{lambdaPhi_SEopt}{Optimal value of the sparsity parameter (corresponding to the endogenous autoregressive parameters) as selected by the time-series cross-validation procedure and after applying the one-standard-error rule}
\item{lambdaB_opt}{Optimal value of the sparsity parameter (corresponding to the exogenous autoregressive parameters) as selected by the time-series cross-validation procedure}
\item{lambdaB_SEopt}{Optimal value of the sparsity parameter (corresponding to the exogenous autoregressive parameters) as selected by the time-series cross-validation procedure and after applying the one-standard-error rule}
\item{MSFEcv}{MSFE cross-validation scores for each value in the two-dimensional sparsity grid}
\item{h}{Forecast horizon h}
}
\description{
Sparse Estimation of the Vector AutoRegressive  with Exogenous Variables X (VARX) Model
}
\examples{
data(varx.example)
VARXfit <- sparseVARX(Y=scale(Y.varx), X=scale(X.varx)) # sparse VARX
y <- matrix(Y.varx[,1], ncol=1)
ARXfit <- sparseVARX(Y=y, X=X.varx) # sparse ARX
}
\references{
Wilms Ines, Sumanta Basu, Bien Jacob and Matteson David S. (2017), “Interpretable vector autoregressions with exogenous time series”, NIPS 2017 Symposium on Interpretable Machine Learning, arXiv:1711.03623.
}
\seealso{
\link{lagmatrix} and \link{directforecast}
}
