% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OGK.R
\name{covrob_ogk}
\alias{covrob_ogk}
\alias{dist_ogk}
\title{Robust Location and Scatter Estimation - Ortogonalized Gnanadesikan-Kettenring (OGK)}
\usage{
covrob_ogk(U, niter = 2, beta = 0.9)

dist_ogk(U, niter = 2, beta = 0.9)
}
\arguments{
\item{U}{A matrix with no missing values and at least 2 columns.}

\item{niter}{Number of number of iterations for the first step of the algorithm,
usually 1 or 2 since iterations beyond the second do not lead to improvement.}

\item{beta}{Coverage parameter for the final reweighted estimate.
Default is \code{0.9}.}
}
\value{
\code{covrob_ogk()}: list of robust estimates, \verb{$cov} and \verb{$center}.

\code{dist_ogk()}: vector of robust Mahalanobis (squared) distances.
}
\description{
Computes a robust multivariate location and scatter estimate with a high
     breakdown point, using the pairwise algorithm proposed by Marona and
     Zamar (2002) which in turn is based on the pairwise robust estimator
     proposed by Gnanadesikan-Kettenring (1972).
}
\details{
The method proposed by Marona and Zamar (2002) allowes to obtain
    positive-definite and almost affine equivariant robust scatter matrices
    starting from any pairwise robust scatter matrix. The default robust estimate
    of covariance between two random vectors used is the one proposed by
    Gnanadesikan and Kettenring (1972) but the user can choose any other method by
    redefining the function in slot \code{vrob} of the control object
    \code{CovControlOgk}. Similarly, the function for computing the robust
    univariate location and dispersion used is the \code{tau scale} defined
    in Yohai and Zamar (1998) but it can be redefined in the control object.

    The estimates obtained by the OGK method, similarly as in \code{CovMcd} are returned
    as 'raw' estimates. To improve the estimates a reweighting step is performed using
    the coverage parameter \code{beta} and these reweighted estimates are returned as
    'final' estimates.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
svd <- svds(scale(X), k = 5)

U <- svd$u
dist <- dist_ogk(U)
str(dist)
}
\references{
Maronna, R.A. and Zamar, R.H. (2002)
  Robust estimates of location and dispersion of high-dimensional datasets;
  \emph{Technometrics} \bold{44}(4), 307--317.

  Yohai, R.A. and Zamar, R.H. (1998)
  High breakdown point estimates of regression by means of the minimization of efficient scale
  \emph{JASA} \bold{86}, 403--413.

  Gnanadesikan, R. and John R. Kettenring (1972)
  Robust estimates, residuals, and outlier detection with multiresponse data.
  \emph{Biometrics} \bold{28}, 81--124.

  Todorov V & Filzmoser P (2009),
  An Object Oriented Framework for Robust Multivariate Analysis.
  \emph{Journal of Statistical Software}, \bold{32}(3), 1--47.
  URL \url{http://www.jstatsoft.org/v32/i03/}.
}
\seealso{
\code{\link[rrcov:CovOgk]{rrcov::CovOgk()}}

\code{\link[stats:mahalanobis]{stats::mahalanobis()}}
}
