% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store-bikedata.R
\name{store_bikedata}
\alias{store_bikedata}
\title{Store hire bicycle data in SQLite3 database}
\usage{
store_bikedata(bikedb, city, data_dir, create_index = TRUE, dates = NULL,
  quiet = FALSE)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database to 
use. If it doesn't already exist, it will be created, otherwise data
will be appended to existing database.  If no directory specified,
it is presumed to be in \code{tempdir()}.}

\item{city}{One or more cities for which to download and store bike data, or
names of corresponding bike systems (see Details below).}

\item{data_dir}{A character vector giving the directory containing the
data files downloaded with \code{dl_bikedata} for one or more
cities. Only if this parameter is missing will data be downloaded.}

\item{create_index}{If TRUE, creates an index on the start and end station
IDs and start and stop times.}

\item{dates}{If specified and no \code{data_dir} is given, data are
downloaded and stored only for these dates specified as vector of YYYYMM
values.}

\item{quiet}{If FALSE, progress is displayed on screen}
}
\value{
Number of trips added to database
}
\description{
Store hire bicycle data in SQLite3 database
}
\note{
Data for different cities are all stored in the same database, with
city identifiers automatically established from the names of downloaded data
files. This function can take quite a long time to execute (typically > 10
minutes), and generates a SQLite3 database file several gigabytes in size.
Downloaded data files are removed after loading into the database; files may
be downloaded and stored permanently with \code{dl_bikedata}, and the
corresponding \code{data_dir} passed to this function.
}
\section{Details}{

City names are not case sensitive, and must only be long enough to
unambiguously designate the desired city. Names of corresponding bike systems
can also be given.  Currently possible cities (with minimal designations in
parentheses) and names of bike hire systems are:
\tabular{lr}{
 New York City (ny)\tab Citibike\cr
 Washington, D.C. (dc)\tab Capital Bike Share\cr
 Chicago (ch)\tab Divvy Bikes\cr
 Los Angeles (la)\tab Metro Bike Share\cr
 Boston (bo)\tab Hubway\cr
 Philadelphia (ph)\tab Indego\cr
}
}

\examples{
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
# or download some real data!
# dl_bikedata (city = 'la', data_dir = data_dir)
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
trips <- bike_tripmat (bikedb = bikedb, city = 'LA') # trip matrix
stations <- bike_stations (bikedb = bikedb) # station data

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files (data_dir, pattern = '.zip'))
}
}
