% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{billboard-theme}
\alias{billboard-theme}
\alias{set_theme}
\alias{set_color_palette}
\title{Set theme and default colors for Billboard charts}
\usage{
set_theme(name = c("billboard", "insight", "graph", "datalab"))

set_color_palette(colors)
}
\arguments{
\item{name}{Name of the theme, possible values are : \code{"billboard"},
\code{"insight"}, \code{"graph"}, \code{"datalab"}.}

\item{colors}{Vector of colors to use as default.}
}
\description{
Set theme and default colors for Billboard charts
}
\note{
You can only use one theme and palette at a time (in Shiny applications or Markdown documents).
}
\examples{
library("billboarder")
set_theme("insight")

data("prod_par_filiere")
billboarder() \%>\%
  bb_barchart(
    data = prod_par_filiere[, c("annee", "prod_hydraulique", "prod_eolien", "prod_solaire")]
  ) \%>\%
  bb_data(
    names = list(prod_hydraulique = "Hydraulic", prod_eolien = "Wind", prod_solaire = "Solar")
  ) \%>\% 
  bb_y_grid(show = TRUE) \%>\%
  bb_y_axis(tick = list(format = suffix("TWh")),
            label = list(text = "production (in terawatt-hours)", position = "outer-top")) \%>\% 
  bb_legend(position = "inset", inset = list(anchor = "top-right")) \%>\% 
  bb_labs(title = "Renewable energy production",
          caption = "Data source: RTE (https://opendata.rte-france.com)")
}
