% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboarder-shiny.R
\name{billboarder-shiny}
\alias{billboarder-shiny}
\alias{billboarderOutput}
\alias{renderBillboarder}
\alias{billboarderProxy}
\title{Shiny bindings for billboarder}
\usage{
billboarderOutput(outputId, width = "100\%", height = "400px")

renderBillboarder(expr, env = parent.frame(), quoted = FALSE)

billboarderProxy(
  shinyId,
  data = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a billboarder}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{shinyId}{single-element character vector indicating the output ID of the
chart to modify (if invoked from a Shiny module, the namespace will be added
automatically)}

\item{data}{A \code{data.frame}.}

\item{session}{the Shiny session object to which the chart belongs; usually the
default value will suffice}
}
\description{
Output and render functions for using billboarder within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(shiny)
  
  ui <- fluidPage(
    tags$h2("Include billboard charts in Shiny"),
    fluidRow(
      column(
        width = 6,
        billboarderOutput("mybb1"),
        tags$p("Click on a bar to get the value:"),
        verbatimTextOutput("res_click")
      ),
      column(
        width = 6,
        billboarderOutput("mybb2")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    output$mybb1 <- renderBillboarder({
      
      dat <- data.frame(
        label = paste("Label", 1:5),
        value = sample.int(100, 5)
      )
      
      billboarder() \%>\%
        bb_barchart(
          data = dat,
          mapping = bbaes(label, value),
          rotated = TRUE
        )
    })
    
    output$res_click <- renderPrint({
      input$mybb1_click
    })
    
    
    output$mybb2 <- renderBillboarder({
      
      data(AirPassengers)
      
      air_passengers <- data.frame(
        date = as.Date(paste(
          rep(1949:1960, each = 12),
          rep(1:12, times = 12),
          "01", sep = "-"
        )), 
        passengers = AirPassengers
      )
      
      billboarder() \%>\% 
        bb_linechart(
          data = air_passengers, 
          mapping = bbaes(date, passengers), type = "spline"
        ) \%>\% 
        bb_x_axis(tick = list(format = "\%Y", fit = FALSE))
    })
    
  }
  
  shinyApp(ui, server)
}
}
\seealso{
\code{\link{proxy_example}}
}
