% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboarder-shiny.R
\name{bb_proxy_legend}
\alias{bb_proxy_legend}
\title{Show or hide legend with proxy}
\usage{
bb_proxy_legend(proxy, what = c("show", "hide"), targetIds = NULL)
}
\arguments{
\item{proxy}{A \code{billboardProxy} \code{htmlwidget} object.}

\item{what}{\code{show} or \code{hide} the legend.}

\item{targetIds}{Series ids to show/hide, if \code{NULL} show/hide all legend.}
}
\value{
A \code{billboardProxy} \code{htmlwidget} object.
}
\description{
Show or hide legend with proxy
}
\examples{
if (interactive()) {
  library("shiny")

  data("prod_par_filiere")

  ui <- fluidPage(
    tags$h2("Show or hide legend with Proxy"),
    fluidRow(
      column(
        width = 3,
        checkboxInput(
          inputId = "show_legend",
          label = "Show legend",
          value = TRUE
        ),
        checkboxGroupInput(
          inputId = "item_show",
          label = "Item to show in legend",
          choices = c("Hydraulic" = "prod_hydraulique",
                      "Wind" = "prod_eolien",
                      "Solar" = "prod_solaire"),
          selected = c("prod_hydraulique", "prod_eolien", "prod_solaire")
        )
      ),
      column(
        width = 9,
        billboarderOutput(outputId = "mybb")
      )
    )
  )

  server <- function(input, output, session) {

    output$mybb <- renderBillboarder({
      billboarder() \%>\%
        bb_barchart(
          data = prod_par_filiere[, c(
            "annee", "prod_hydraulique", 
            "prod_eolien", "prod_solaire"
          )],
          stacked = TRUE
        ) \%>\%
        bb_data(
          names = list(prod_hydraulique = "Hydraulic",
                       prod_eolien = "Wind",
                       prod_solaire = "Solar"),
          labels = TRUE
        ) \%>\%
        bb_colors_manual(
          "prod_eolien" = "#41AB5D",
          "prod_hydraulique" = "#4292C6", 
          "prod_solaire" = "#FEB24C"
        ) \%>\%
        bb_y_grid(show = TRUE) \%>\%
        bb_y_axis(
          tick = list(format = suffix("TWh")),
          label = list(text = "production (in terawatt-hours)",
                       position = "outer-top")
        ) \%>\%
        bb_legend(position = "right") \%>\%
        bb_labs(
          title = "Renewable energy production",
          caption = "Data source: RTE (https://opendata.rte-france.com)"
        )
    })

    observe({
      if (input$show_legend) {
        billboarderProxy("mybb") \%>\% 
          bb_proxy_legend(what = "show")
      } else {
        billboarderProxy("mybb") \%>\% 
          bb_proxy_legend(what = "hide")
      }
    })

    observe({
      lapply(
        X = c("prod_hydraulique", "prod_eolien", "prod_solaire"),
        FUN = function(x) {
          if (x \%in\% input$item_show) {
            billboarderProxy("mybb") \%>\%
              bb_proxy_legend(what = "show", targetIds = x)
          } else {
            billboarderProxy("mybb") \%>\%
              bb_proxy_legend(what = "hide", targetIds = x)
          }
        }
      )
    })

  }

  shinyApp(ui = ui, server = server)
}
}
