% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SterrettFunctions.R
\name{ExpTests.Sterrett}
\alias{ExpTests.Sterrett}
\title{Extract the expected number of tests from testing configuration results}
\usage{
\method{ExpTests}{Sterrett}(object, ...)
}
\arguments{
\item{object}{An object of class "Sterrett", from which the expected number
of tests is to be extracted.}

\item{...}{Additional arguments to be passed to \code{ExpTests} (e.g.,
\code{digits} to be passed to \code{round} for appropriate rounding).}
}
\value{
A data frame containing the columns:
\item{ExpTests}{the expected number of tests required to decode all individuals
in the algorithm.}
\item{ExpTestsPerIndividual}{the expected number of tests per individual.}
\item{PercentReductionTests}{The percent reduction in the number of tests; 100 * (1 - ExpTestsPerIndividual).}
\item{PercentIncreaseTestCap}{The percent increase in testing capacity when the algorithm
  is applied to a continuous stream of specimens; 100 * (1/ExpTestsPerIndividual - 1).}
}
\description{
Extract the expected number of tests from objects of class "Sterrett" returned by
\code{\link{Sterrett}} (\kbd{Sterrett}).
}
\examples{
set.seed(1231)
p.vec1 <- rbeta(n = 8, shape1 = 1, shape2 = 10)
save.it1 <- Sterrett(p = p.vec1, Sp = 0.90, Se = 0.95)
ExpTests(save.it1)
}
\references{
\insertRef{bilder2020tests}{binGroup2}
}
\author{
Christopher R. Bilder
}
