% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryS3.R
\name{as.binary}
\alias{as.binary}
\title{as binary digit.}
\usage{
as.binary(x, signed=FALSE, littleEndian=FALSE, size=2, logic=FALSE)
}
\arguments{
\item{x}{integer or logical vector.}

\item{signed}{TRUE or FALSE. Unsigned by default. (two's complement)}

\item{littleEndian}{if TRUE. Big Endian if FALSE.}

\item{size}{in Byte. Needed if \bold{signed} is set. (by default 2 Byte)}

\item{logic}{If set to TRUE, x is expected as logical vector.}
}
\value{
a vector of class binary.
}
\description{
Converts an integer (Base10) 
to a binary (Base2) number. It also converts a logical vector 
to a binary (Base2) number (see examples).
}
\details{
The binary number is represented by a logical vector.
The bit order usually follows the same endianess as the byte order.
No floating-point support. If logic is set to TRUE an integer vector 
is intepreted as a logical vector (>0 becomes TRUE and 0 becomes FALSE)
\itemize{
\item Little Endian    (LSB) ---> (MSB)
\item Big Endian       (MSB) <--- (LSB)
}
Auto switch to signed if num < 0.
}
\examples{
as.binary(0xAF)
as.binary(42)
as.binary(42, littleEndian=TRUE)
as.binary(c(0xAF, 0xBF, 0xFF))
as.binary(c(2,4,8,16,32), signed=TRUE, size=1)
as.binary(-1, signed=TRUE, size=1)
as.binary(c(1,1,0), signed=TRUE, logic=TRUE)
as.binary(c(TRUE,TRUE,FALSE), logic=TRUE)
}
\seealso{
\link{is.binary} and \link{binary}
}

