% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readFiles.R
\name{readFiles}
\alias{readFiles}
\title{Read and process mulitple data files}
\usage{
readFiles(files, dp, scans, sranges = list(c(50, 1000)), modes = c("n",
  "p"), nCores = 1)
}
\arguments{
\item{files}{A vector of converted data file paths}

\item{dp}{An integer denoting the number of decimal places for spectral binning}

\item{scans}{A vector of scan numbers that should be retrieved}

\item{sranges}{A list of vectors containing the scan events present.}

\item{modes}{A vector of strings denoting mode names including the order in which the scan events occur.}

\item{nCores}{The number of cores on which to parallel process.}
}
\value{
A list containing peak lists for the relevant scans with combined scan ranges for each present mode in the data file.
}
\description{
Apply spectral binning on multiple data files.
}
\examples{
res <- readFiles(list.files(system.file('mzML',package = 'binneR'),
                 full.names=TRUE),dp = 2,scans = 6:17)
}
\author{
Jasen Finch
}
