% Generated by roxygen2 (4.0.2): do not edit by hand
\name{count_ngrams}
\alias{count_ngrams}
\title{Detect And Count N-Grams In Sequences}
\usage{
count_ngrams(seq, n, u, d = 0, pos = FALSE, scale = FALSE,
  threshold = 0)
}
\arguments{
\item{seq}{\code{integer} vector or matrix describing sequence(s).}

\item{n}{\code{integer} size of n-gram.}

\item{u}{unigrams (\code{integer}, \code{numeric} or \code{character} vector).}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means
consecutive elements). See Details.}

\item{pos}{\code{logical}, if \code{TRUE} n_grams contains position information.}

\item{scale}{\code{logical}, if \code{TRUE} output data is normalized. Should be
used only for n-grams without position information. See \code{Details}.}

\item{threshold}{\code{integer}, if not equal to 0, data is binarized into
two groups (larger or equal to threshold, smaller than threshold).}
}
\value{
a \code{\link[slam]{simple_triplet_matrix}}. See \code{Details} for specifics of the column naming.
}
\description{
Counts all n-grams present in sequences.
}
\details{
A \code{distance} vector should be always \code{n} - 1 long. For example
when \code{n} = 3, \code{d} = c(1, 2) means A_A__A. For \code{n} = 4,
\code{d} = c(2, 0, 1) means A__AA_A. If vector \code{d} has length 1, it is recycled to
length \code{n} - 1.

Column names follow a specific convention. Elements of n-gram are separated by
dot. If \code{pos} = \code{TRUE}, the left side of name means actual position of the
n-gram (separated by \code{_}). the Right side of name is vector of distance(s)
used separated by \code{_}.

Examples of naming convention:
\itemize{
\item{46_4.4.4_0_1 means trigram 44_4 on position 46.}
\item{12_2.1_2 means bigram 2__1 on position 12.}
\item{8_1.1.1_0_0 means continous trigram 111 on position 8.}
}
}
\examples{
#trigrams without position for nucleotides
count_ngrams(sample(1L:4, 50, replace = TRUE), 3, 1L:4, pos = FALSE)
#trigrams with position from multiple nucleotide sequences
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
count_ngrams(seqs, 3, 1L:4, pos = TRUE)
}
\seealso{
Create vector of possible n-grams: \code{\link{create_ngrams}}.

Get n-grams from analyzed sequence: \code{\link{seq2ngrams}}.

Get indices of n-grams: \code{\link{get_ngrams_ind}}.

Count n-grams for multiple values of n: \code{\link{count_multigrams}}.
}

