% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRNA.R
\name{getRNA}
\alias{getRNA}
\title{RNA Sequence Retrieval}
\usage{
getRNA(db = "refseq", organism, reference = TRUE,
  path = file.path("_ncbi_downloads", "RNA"))
}
\arguments{
\item{db}{a character string specifying the database from which the genome 
shall be retrieved: \code{db = "refseq"}, \code{db = "genbank"}, 
\code{db = "ensembl"} or \code{db = "ensemblgenomes"}.}

\item{organism}{a character string specifying the scientific name of the 
organism of interest,\code{organism = "Homo sapiens"}.}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{path}{a character string specifying the location (a folder) in which 
the corresponding
CDS file shall be stored. Default is 
\code{path} = \code{file.path("_ncbi_downloads","RNA")}.}
}
\value{
File path to downloaded RNA file.
}
\description{
Main retrieval function for RNA sequences of an organism 
of interest. By specifying the scientific name of an organism of interest the
corresponding fasta-file storing the RNA information for the organism 
of interest can be downloaded and stored locally. 
RNA files can be retrieved from several databases.
}
\examples{
\dontrun{
# download the RNA of Arabidopsis thaliana from refseq
# and store the corresponding RNA file in '_ncbi_downloads/RNA'
file_path <- getRNA( db       = "refseq", 
             organism = "Arabidopsis thaliana", 
             path     = file.path("_ncbi_downloads","RNA"))

Ath_RNA <- read_rna(file_path, format = "fasta")
}
}
\seealso{
\code{\link{getGenome}}, \code{\link{getProteome}}, 
\code{\link{getGTF}}, \code{\link{getGFF}}, \code{\link{meta.retrieval}}, 
\code{\link{read_cds}}, \code{\link{getCDS}}
}
\author{
Hajk-Georg Drost
}
