% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGTF.R
\name{getGTF}
\alias{getGTF}
\title{Genome Annotation Retrieval (GTF)}
\usage{
getGTF(db = "ensembl", organism, path = file.path("ensembl",
  "annotation"))
}
\arguments{
\item{db}{a character string specifying the database from which the genome 
shall be retrieved:
\itemize{
\item \code{db = "ensembl"}
}}

\item{organism}{a character string specifying the scientific name of the 
organism of interest, e.g. \code{organism = "Homo sapiens"}.}

\item{path}{a character string specifying the location (a folder) in which 
the corresponding annotation file shall be stored. Default is 
\code{path = file.path("ensembl","annotation")}.}
}
\value{
File path to downloaded annotation file.
}
\description{
Main retrieval function for GTF files of an 
organism of interest. By specifying the scientific name of an organism of 
interest the corresponding GTF file storing the annotation  for the organism 
of interest can be downloaded and stored locally. GTF files can be retrieved 
from several databases.
}
\details{
Internally this function loads the the overview.txt file from ENSEMBL:
and creates a directory 'ensembl/annotation' to store
the genome of interest as fasta file for future processing.
In case the corresponding fasta file already exists within the
'ensembl/annotation' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{
# download the annotation of Arabidopsis thaliana from refseq
# and store the corresponding genome file in 'ensembl/annotation'
getGTF( db       = "ensembl", 
               organism = "Homo sapiens", 
               path = file.path("ensembl","annotation"))

}

}
\seealso{
\code{\link{getProteome}}, \code{\link{getCDS}}, 
\code{\link{getGenome}}, \code{\link{getRNA}}, \code{\link{getRepeatMasker}}, 
\code{\link{getAssemblyStats}}, \code{\link{meta.retrieval}},
\code{\link{getGFF}}
}
\author{
Hajk-Georg Drost
}
