% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_graph.R
\name{summary_graph}
\alias{summary_graph}
\title{Visualise a graphical summary of variables from a data frame}
\usage{
summary_graph(data, response, exp_var, resp_units = "")
}
\arguments{
\item{data}{A data frame containing the variables to be plotted.}

\item{response}{The response variable to plot.}

\item{exp_var}{The explanatory (or grouping) variable(s) to plot. Up to three can be provided.}

\item{resp_units}{A string providing units to display on the response variable (y) axis. Will use the empty string by default so axes will have no units by default.}
}
\value{
A ggplot2 plot object
}
\description{
Variables are plotted in different ways according to the number of explanatory
variables provided as input.
}
\details{
With a single explanatory variable, a boxplot grouped by \code{exp_var} is produced.
With two explanatory variables, a dot-plot with lines connecting the mean of each
group is produced, with the first element of \code{exp_var} used as the x axis variable,
and the second is used to colour the points. Three explanatory variables produces
the same as two, but with the third used to facet the plot.
}
\examples{

summary_graph(iris, "Petal.Length", "Species", "mm")

# Multiple
summary_graph(npk, "yield", c("N", "P"), "lb/plot")

summary_graph(npk, "yield", c("N", "P", "K"), "lb/plot")

}
