% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillLineGaps.R
\name{fillLineGaps}
\alias{fillLineGaps}
\title{Reconnecting discontinuous lines}
\usage{
fillLineGaps(
  droplet.img,
  bead.img = NULL,
  threshold = "13\%",
  alpha = 0.75,
  sigma = 0.1,
  radius = 5,
  iterations = 2,
  visualize = TRUE
)
}
\arguments{
\item{droplet.img}{image that contains discontinuous lines like edges or
contours}

\item{bead.img}{image that contains objects that should be removed before
before applying the fill algorithm}

\item{threshold}{"in \%" (from \code{\link[imager]{threshold}})}

\item{alpha}{threshold adjustment factor for edge detection
(from \code{\link[imager]{cannyEdges}})}

\item{sigma}{smoothing (from \code{\link[imager]{cannyEdges}})}

\item{radius}{maximal radius that should be scanned for another cluster}

\item{iterations}{how many times the algorithm should find line ends and
reconnect them to their closest neighbor}

\item{visualize}{if TRUE (default) a plot is displayed highlighting the
added pixels in the original image}
}
\value{
image with continuous edges (closed gaps)
}
\description{
The function attempts to fill in edge discontinuities in order to enable
normal labeling and edge detection.
}
\details{
The function pre-processes the image to enable the application of
adaptiveInterpolation. Pre-processing involves thresholding, optional
object removal, LineEnd and diagonal LineEnd detection, and labeling. The
threshold should be set to allow for some remaining "bridge" pixels between
gaps to facilitate reconnection. For more details about reconnection,
please consult adaptiveInterpolation.
Post-processing involves thinning the lines. When removing objects from an
image, their coordinates are collected using the objectDetection function.
Next, the pixels of the detected objects are nullified in the original
image, allowing the algorithm to proceed without the objects.
}
\examples{
fillLineGaps(droplets)
}
