#' Image of microbeads
#'
#' This fluorescence image, formatted as 'cimg' with dimensions of
#' 492 x 376 pixels, shows microbeads. With a single color channel, the image
#' provides an ideal example for in-depth analysis of microbead structures.
#' The image's larger size encompasses a greater number of microbeads,
#' offering a broader range of experimental outcomes for examination.
#'
#' @format
#' The image was imported using imager and is therefore of class:
#' "cimg" "imager_array" "numeric"
#' @details
#' Dimensions: width - 492; height - 376; depth - 1; channel - 1
#' @references The image was provided by Coline Kieffer.
#' @examples
#' data(beads_large1)
#' plot(beads_large1)
"beads_large1"
