% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haralickCluster.R
\name{haralickCluster}
\alias{haralickCluster}
\title{k-medoids clustering of images according to the Haralick features}
\usage{
haralickCluster(path)
}
\arguments{
\item{path}{directory path to folder with images to be analyzed}
}
\value{
\code{data.frame} containing file names, md5sums and cluster number.
}
\description{
This function performs k-medoids clustering on images using Haralick
features, which describe texture. By evaluating contrast, correlation,
entropy, and homogeneity, it groups images into clusters with similar
textures. K-medoids is chosen for its outlier resilience, using actual
images as cluster centers. This approach simplifies texture-based image
analysis and classification.
}
\examples{
\donttest{
  path2dir <- system.file("images", package = 'biopixR')
  result <- haralickCluster(path2dir)
  print(result)
}
}
\references{
https://cran.r-project.org/package=radiomics
}
