% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_misc_operations.R
\name{seq_spellout}
\alias{seq_spellout}
\title{Spell out sequences}
\usage{
seq_spellout(x, short = FALSE, collapse = " - ")
}
\arguments{
\item{x}{a DNA, RNA or AA vector}

\item{short}{logical. If TRUE, the function will return
3-letters short names for amino acids (ignored for DNA and RNA).}

\item{collapse}{a character vector to separate the results.
Set to \code{NULL} to avoid collapsing the results.}
}
\value{
A character vector if collapse is not \code{NULL}.
A list of character vectors otherwise.
}
\description{
This function spells out nucleotides and amino acids in sequences.
}
\examples{
x <- dna("ACGT")
seq_spellout(x)

x <- rna("ACGU")
seq_spellout(x)

x <- aa("ACGBTX")
seq_spellout(x)

}
\seealso{
Other op-misc: \code{\link{seq_disambiguate_IUPAC}},
  \code{\link{seq_nchar}}, \code{\link{seq_nseq}},
  \code{\link{seq_stat_gc}}, \code{\link{seq_stat_prop}}
}
\concept{op-misc}
