% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot_trend}
\alias{plot_trend}
\title{Plotting posterior trends}
\usage{
plot_trend(
  x,
  CI_group = 1,
  n_points = 1000,
  quantiles = c(0.99, 0.9, 0.5, 0.25),
  quantile.col = gray(seq(1, 0, length.out = length(quantiles) + 2)[2:(length(quantiles)
    + 1)]),
  quantile.border = NA,
  median.col = "deeppink",
  median.lwd = 1,
  median.lty = 1,
  epoch.col = "black",
  epoch.lwd = 1,
  epoch.lty = 1,
  times.col = "black",
  times.lwd = 1,
  times.lty = 2,
  log = FALSE,
  xlab = "Time",
  ylab = paste(c("log", "Relative Density")[c(log, TRUE)], collapse = " "),
  main = x$CI_groups[CI_group],
  ...
)
}
\arguments{
\item{x}{A birp object}

\item{CI_group}{The index of the control-intervention (CI) group to plot. By default, the first group is plotted.}

\item{n_points}{Number of points}

\item{quantiles}{Which quantiles to plot}

\item{quantile.col}{Colors of the quantiles}

\item{quantile.border}{Define border of the quantile. NA is possible}

\item{median.col}{Color of the median}

\item{median.lwd}{Line width of median}

\item{median.lty}{Line type of median}

\item{epoch.col}{Color to represent the epochs}

\item{epoch.lwd}{Line width to represent the epochs}

\item{epoch.lty}{Line type to represent the epochs}

\item{times.col}{Color to represent the times of change}

\item{times.lwd}{Line width that represents times of change}

\item{times.lty}{Line type that represents times of change}

\item{log}{Plot relative densities in log}

\item{xlab}{A label for the x axis}

\item{ylab}{A label for the y axis}

\item{main}{A title for the plot}

\item{...}{additional parameters passed to the function}
}
\value{
No return value, called for side effects
}
\description{
Plotting posterior trends
}
\examples{
data <- simulate_birp()
est <- birp(data)
plot_trend(est)
}
\seealso{
\code{\link{birp}}
}
