% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{birp}
\alias{birp}
\title{Create a \code{birp} Object}
\usage{
birp(
  data,
  timesOfChange = c(),
  negativeBinomial = FALSE,
  stochastic = FALSE,
  BACI = NULL,
  assumeTrueDetectionProbability = FALSE,
  iterations = 1e+05,
  numBurnin = 10,
  burnin = 1000,
  thinning = 10,
  verbose = TRUE
)
}
\arguments{
\item{data}{A \link{birp_data} object containing the input data.}

\item{timesOfChange}{Numeric or integer vector specifying the times of change (change points) for the model.}

\item{negativeBinomial}{Logical; if \code{TRUE}, fits a negative binomial model instead of the default Poisson model.}

\item{stochastic}{Logical; if \code{TRUE}, fits a stochastic trend model instead of the default deterministic trend model.}

\item{BACI}{Optional matrix specifying the BACI (Before-After-Control-Impact) design. Each row corresponds to a control/intervention group and each column to an epoch. The first column contains the control-intervention group names (matching those in \code{data}), and subsequent columns specify which gamma (rate of change) parameter to use for each group and epoch. For example, \code{BACI = matrix(c("A", "B", 1, 1, 1, 2), nrow = 2)} corresponds to a canonical BACI design with control group "A" and intervention group "B".}

\item{assumeTrueDetectionProbability}{Logical; if \code{TRUE}, provided detection probabilities are treated as true probabilities (logit-transformed without standardization).}

\item{iterations}{Integer; total number of MCMC iterations to run.}

\item{numBurnin}{Integer; number of burn-in cycles to run.}

\item{burnin}{Integer; number of MCMC iterations per burn-in cycle.}

\item{thinning}{Integer; thinning interval for saving MCMC samples. Only every \code{thinning}th iteration is retained.}

\item{verbose}{Logical; if \code{FALSE}, suppresses console output.}
}
\value{
An object of type \code{birp} containing MCMC results and model estimates.
}
\description{
This function runs the Markov Chain Monte Carlo (MCMC) algorithm on a \code{birp_data} object to estimate model parameters and returns a fitted \code{birp} object.
}
\examples{
data <- simulate_birp()
est <- birp(data)
}
