% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hp.R
\encoding{UTF-8}
\name{plot_hp}
\alias{plot_hp}
\title{plot Hyper-prior function}
\usage{
plot_hp(hpf, col = c("#bfdbf7", "#f49e4c"), border = c("#2e86ab",
  "#a31621"), bty = "n", ...)
}
\arguments{
\item{hpf}{name of a density function. Supported density functions are: Uniform, Gamma and Normal}

\item{col}{color of the density area. Can be of size 2 (hpriors for the means, hpriors for the logvars) if a jive object is plotted}

\item{border}{color of the density curve. Can be of size 2 (hpriors for the means, hpriors for the logvars) if a jive object is plotted}

\item{bty, ...}{additional parameters that can be passed to a density function and  \code{\link[graphics]{par}}}
}
\description{
This function plots a hyper-prior density function. 
Currently supported density function are Uniform, Gamma, Normal, Loggamma and Lognormal. 
The resulting function is used during MCMC \code{\link{mcmc_bite}}
to estimate parameters of priors.
}
\details{
There are three currently implemented density function: 
Uniform, Gamma and Normal. Each of these densities requires two input parameters and hp.pars 
must be a vector of two values and cannot be left empty.
}
\examples{

 ## Load test data
 data(Anolis_traits)
 data(Anolis_tree)
   
 my.hp <- hpfun(hpf="Uniform", hp.pars=c(1,2))
 plot_hp(my.hp)
 
 my.jive <- make_jive(Anolis_tree, Anolis_traits[,-3], model.priors = list(mean="BM", logvar="OU"))
 plot_hp(my.jive, cex.main = .8)
}
\author{
Theo Gaboriau
}
