% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_email_creds_file.R
\name{create_email_creds_file}
\alias{create_email_creds_file}
\title{Create a file with email access credentials}
\usage{
create_email_creds_file(user, password, provider = NULL, host = NULL,
  port = NULL, sender = NULL, use_ssl = TRUE, use_tls = FALSE,
  authenticate = TRUE, creds_file_name = NULL)
}
\arguments{
\item{user}{the username for the email account.}

\item{password}{the password associated with the
email account.}

\item{provider}{an optional provider email provider
with which an STMP account is available. Options
currently include \code{gmail}, \code{outlook},
and \code{office365}. If nothing is provided then
values for \code{host}, \code{port},
\code{sender}, \code{use_ssl}, \code{use_tls},
and \code{authenticate} are expected.}

\item{host}{the \code{host} name.}

\item{port}{the port number.}

\item{sender}{the sender name.}

\item{use_ssl}{an option as to whether to use
SSL; supply a \code{TRUE} or \code{FALSE}
value (\code{TRUE} is the default value).}

\item{use_tls}{a logical value to
indicate whether to use TLS; supply a \code{TRUE}
or \code{FALSE} value (\code{FALSE} is the
default value).}

\item{authenticate}{an option as to whether to
authenticate; supply a \code{TRUE} or \code{FALSE}
value (\code{TRUE} is the default value).}

\item{creds_file_name}{an option to specify a
name for the credentials file. If no name is
provided, one will be automatically generated.
The autogenerated file will be invisible and
have its name constructed in the following way:
\code{.bls_<host_name>}.}
}
\description{
Create a file with access credentials for
the purpose of automatically emailing
notification messages.
}
\examples{
\dontrun{
# Create a credentials file to facilitate
# the sending of email messages
create_email_creds_file(
  user = "user_name@gmail.com",
  password = "************",
  provider = "gmail")
}
}
