% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_plot.R
\name{cv_plot}
\alias{cv_plot}
\title{Visualising folds created by blockCV in ggplot}
\usage{
cv_plot(
  cv,
  x,
  r = NULL,
  nrow = NULL,
  ncol = NULL,
  num_plots = 1:10,
  max_pixels = 3e+05,
  remove_na = TRUE,
  raster_colors = gray.colors(10, alpha = 1),
  points_colors = c("#E69F00", "#56B4E9"),
  points_alpha = 0.7,
  label_size = 4
)
}
\arguments{
\item{cv}{a blockCV cv_* object; a \code{cv_spatial}, \code{cv_cluster}, \code{cv_buffer}
or \code{cv_nndm}}

\item{x}{a simple features (sf) or SpatialPoints object of the spatial sample data used for creating
the \code{cv} object. This could be empty when \code{cv} is a \code{cv_spatial} object.}

\item{r}{a terra SpatRaster object (optional). If provided, it will be used as background of the plots.
It also supports \emph{stars}, \emph{raster}, or path to a raster file on disk.}

\item{nrow}{integer; number of rows for facet plot}

\item{ncol}{integer; number of columns for facet plot}

\item{num_plots}{a vector of indices of folds; by default the first 10 are shown (if available).
You can choose any of the folds to be shown e.g. \code{1:3} or \code{c(2, 7, 16, 22)}}

\item{max_pixels}{integer; maximum number of pixels used for plotting \code{r}}

\item{remove_na}{logical; whether to remove excluded points in \code{cv_buffer} from the plot}

\item{raster_colors}{character; a character vector of colours for raster background e.g. \code{terrain.colors(20)}}

\item{points_colors}{character; two colours to be used for train and test points}

\item{points_alpha}{numeric; the opacity of points}

\item{label_size}{integer; size of fold labels when a \code{cv_spatial} object is used.}
}
\value{
a ggplot object
}
\description{
This function visualises the folds create by blockCV. It also accepts a raster
layer to be used as background in the output plot.
}
\examples{
\donttest{
library(blockCV)

# import presence-absence species data
points <- read.csv(system.file("extdata/", "species.csv", package = "blockCV"))
pa_data <- sf::st_as_sf(points, coords = c("x", "y"), crs = 7845)

# spatial clustering
sc <- cv_cluster(x = pa_data, k = 5)

# now plot the create folds
cv_plot(cv = sc,
        x = pa_data, # sample points
        nrow = 2,
        points_alpha = 0.5)

}
}
