% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.blockcpd}
\alias{plot.blockcpd}
\title{Plot for blockcpd object}
\usage{
\method{plot}{blockcpd}(
  x,
  ...,
  parameter = NULL,
  index_values = NULL,
  index_variable_name = "Index",
  pkg = "base"
)
}
\arguments{
\item{x}{A fitted blockcpd S3 object provided by the
\link[=fit_blockcpd]{fit_blockcpd} function.}

\item{...}{Other parameters}

\item{parameter}{The parameter of the family for which to plot the blocked}

\item{index_values}{A numerical vector of size ncol that contains the values
of the the variable corresponding to the change points. For example, if your
segmented variable corresponds to a time samples from 0 to 150 sampled each
15 seconds, the model treats these as values from 1 to 11. To plot on the
variable scale, pass the argument 'index_values = seq(0, 150, 15)'.}

\item{index_variable_name}{Name of the variable segmented.}

\item{pkg}{Graphical package to be used for plotting. Current values are
"base".}
}
\value{
No return value.
}
\description{
Plots the selected parameters in a blocked fashion.
}
\examples{
plot(fit_blockcpd(c(1,2,3, 4), family = "exponential", lambda = 0))
}
