% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-class.R
\name{new_board}
\alias{new_board}
\alias{validate_board}
\alias{is_board}
\title{Board}
\usage{
new_board(
  blocks = list(),
  links = list(),
  stacks = list(),
  options = new_board_options(),
  ...,
  class = character()
)

validate_board(x)

is_board(x)
}
\arguments{
\item{blocks}{Set of blocks}

\item{links}{Set of links}

\item{stacks}{Set of stacks}

\item{options}{Board-level user settings}

\item{...}{Further (metadata) attributes}

\item{class}{Board sub-class}

\item{x}{Board object}
}
\value{
The board constructor \code{new_board()} returns a \code{board} object, as does
the validator \code{validate_board()}, which typically is called for side effects
in the form of errors. Inheritance checking as \code{is_board()} returns a scalar
logical.
}
\description{
A set of blocks, optionally connected via links and grouped into stacks
are organized as a \code{board} object. Boards are constructed using \code{new_board()}
and inheritance can be tested with \code{is_board()}, while validation is
available as (generic function) \code{validate_board()}. This central data
structure can be extended by adding further attributes and sub-classes. S3
dispatch is used in many places to control how the UI looks and feels and
using this extension mechanism, UI aspects can be customized to user
requirements. Several utilities are available for retrieving and modifying
block attributes (see \code{\link[=board_blocks]{board_blocks()}}).
}
\examples{
brd <- new_board(
  c(
     a = new_dataset_block(),
     b = new_subset_block()
  ),
  list(from = "a", to = "b")
)

is_board(brd)

}
