% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppMOLS.R
\name{MOLS}
\alias{MOLS}
\title{Prime power MOLS from finite fields}
\usage{
MOLS(p, q, r)
}
\arguments{
\item{p}{is any odd prime greater than one}

\item{q}{is any suitable integer power (see description for available powers)}

\item{r}{is any number of squares up to a maximum of p**q - 1}
}
\value{
Data frame of factor levels for rows, columns and treatmnent sets
}
\description{
Constructs sets of mutually orthogonal Latin squares (MOLS) of dimension p**q where p is 
prime. The number of squares r can be any number less than p**q and the exponent q can
be any value from 1 up to a maximum dependent on the choice of p, viz:

 q < 13 for p = 2; q < 8 for p = 3; q < 6 for p = 5; q < 5 for p = 7;
 q < 4 for p = 11, 13, 17, 19; q < 3 for any other p < 100; q = 1 for any other p > 100.
}
\details{
Generates MOLS by cyclic permuation of a basic Latin square L0 constructed
from a vector of ordered elements X of a prime-power finite field of size
p**q and a unit vector 1 of length p**q (see Chapter 1 of Raghavarao 1971).

\eqn{L0 = crossprod(X,t(1)) + crosssprod(1,t(X))}

The primitive polynomials for the MOLS generated by this package were
extracted from the Table of Primitive Polynomials given in the Supplement to Hansen and Mullen (1992).

The output is a single data frame for a \eqn{p**q x p**q} square classified by rows and columns 
with a separate column for the allocation of treatments to each individual square.
}
\examples{

MOLS(2,3,7)
MOLS(3,2,4)
\donttest{MOLS(3,3,4)}
\donttest{MOLS(23,2,2)}
 
}
\references{
Hansen, T. & Mullen, G. L. (1992) Primitive polynomials over finite fields,
Mathematics of Computation, 59, 639-643 and Supplement. 

Raghavarao D. (1971) Constructions and Combinatorial Problems in Design of Experimnents,
Dover Publications, Inc.
}
