% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squarelattice.R
\name{squarelattice}
\alias{squarelattice}
\title{Square lattice designs}
\usage{
squarelattice(v, r)
}
\arguments{
\item{v}{is the required block size and is the integer square root of the required number of treatments}

\item{r}{is is the required number of replicates}
}
\description{
Internal function constructs square lattice designs for resolvable nested block designs with 
v*v treatments, r complete replicate blocks and nested blocks of size v. 

Returns a simple lattice with r = 2 or a triple lattice with
r = 3 for any size of v. 

Returns a quadruple lattice with r = 4 for any v <= 30.

Returns a lattice for any r < v + 2 if v is a prime or prime power with p^q less than or equal to:

\itemize{
\item{2**12} 
\item{3**7} 
\item{5**5} 
\item{7**4} 
\item{(11,13,17,19)**3}  
\item{(23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97)**2}
}
}
\keyword{internal}
