% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-regress.R
\name{blr_regress}
\alias{blr_regress}
\alias{blr_regress.glm}
\title{Binary logistic regression}
\usage{
blr_regress(object, ...)

\method{blr_regress}{glm}(object, odd_conf_limit = FALSE, ...)
}
\arguments{
\item{object}{An object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted or class
\code{glm}.}

\item{...}{Other inputs.}

\item{odd_conf_limit}{If TRUE, odds ratio confidence limts will be displayed.}
}
\description{
Binary logistic regression.
}
\examples{
# using formula
blr_regress(object = honcomp ~ female + read + science, data = hsb2)

# using a model built with glm
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))

blr_regress(model)

# odds ratio estimates
blr_regress(model, odd_conf_limit = TRUE)

}
