% Generated by roxygen2 (4.0.0): do not edit by hand
\name{aggregateConstraints}
\alias{aggregateConstraints}
\title{Aggregate constraints.}
\usage{
aggregateConstraints(...)
}
\arguments{
\item{...}{constraint functions. Must have take a single argument and return
a single value.}
}
\value{
a function which takes a value \code{X} and returns a vector with
length equal to \code{length(...)}. The i-th entry of the return value is the
i-th constraint function evaluated at \code{X}.
}
\description{
Collect constraint functions into a vector.
}
\examples{
g1 <- function(X) {
as.numeric(c(1,1,1) \%*\% X^4 - 1)
}

g2 <- function(X) {
  as.numeric(c(1,1,1) \%*\% X^2 - 1)
}

G <- aggregateConstraints(g1, g2)
G(c(1,1,1))
}
\seealso{
Other aggregate functions: \code{\link{aggregateGradients}};
  \code{\link{aggregateHessians}}
}

