% Generated by roxygen2 (4.0.0): do not edit by hand
\name{build_h}
\alias{build_h}
\title{Assemble h}
\usage{
build_h(G, Df, DG)
}
\arguments{
\item{G}{a vector valued constraint function which takes input \code{X} and
should yield a vector of 0's when all constraints are satisfied. See
\code{\link{aggregateConstraints}}.}

\item{Df}{a vector valued function representing the gradient of the objective
function, \code{f}. \code{Df} should take \code{(X,lambda)} as primary
arguments, though it must take \code{(X, lambda, data)} as arguments if
\code{\link{SGD}} is to be used.}

\item{DG}{a matrix valued function representing the matrix of gradients of
constraint functions. See \code{\link{aggregateGradients}}.}
}
\value{
a scalar-valued function \code{h(X, lambda, data)} which is half the
squared euclidean norm of the gradient of the Lagrangian created by \code{f}
and \code{G}.
}
\description{
Build h from the first derivatives of the object and constraint
functions.
}
\details{


The definition for \code{h} and \code{Dh} can be found in
\code{inst/final_project/final_paper/final_paper.pdf}.
}
\examples{
Df <- function(X){
x <- X[1]; y <- X[2]; z <- X[3]
c(1 + 2*x + y + z, 1 + x + 2*y + z, 1 + x + y + 2*z)
}

g1 <- function(X) {
  as.numeric(c(1,1,1) \%*\% X^4 - 1)
}

g2 <- function(X) {
  as.numeric(c(1,1,1) \%*\% X^2 - 1)
}

Dg1 <- function(X){
  4 * X^3
}

Dg2 <- function(X){
  2 * X
}

h <- build_h(G=aggregateConstraints(g1, g2),
             Df=Df,
             DG=aggregateGradients(Dg1, Dg2))

h(c(1,1,1), c(1,1))
}
\seealso{
Other blowtorch wrappers: \code{\link{buildDh}}
}

