% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsQCEW.R
\name{blsQCEW}
\alias{blsQCEW}
\title{Request QCEW Data from the U.S. Bureau Of Labor Statistics Open Data Access}
\usage{
blsQCEW(method, year = NA, quarter = NA, area = NA, industry = NA,
  size = NA)
}
\arguments{
\item{method}{a string describing which type of data you want requested.  Valid options are: Area, Industry and Size.  The method is not case sensitive.}

\item{year}{a string for the year of data you want}

\item{quarter}{a string indicating the quarter (1, 2, 3 or 4) or "a" for the annual average.}

\item{area}{a string indicating which area you want the data for.  See <\url{https://www.bls.gov/cew/doc/titles/area/area_titles.htm}> for all area codes and titles.}

\item{industry}{a string for the NAICS code.  Some industry codes contain hyphens but the open data access uses underscores instead of hyphens. So 31-33 becomes 31_33. For all industry codes and titles see: <\url{https://www.bls.gov/cew/doc/titles/industry/industry_titles.htm}>}

\item{size}{a string for the size code. See <\url{https://www.bls.gov/cew/doc/titles/size/size_titles.htm}> for all establishment size classes and titles.  Note: Size data is only available for the first quarter of each year.}
}
\description{
Allows users to request quarterly census of employment and wages (QCEW) data from the U.S. Bureau of Labor Statistics open access.  Users provide parameters and the function returns a data frame.  This function is based off of the sample code developed by the BLS that is found at <\url{https://www.bls.gov/cew/doc/access/data_access_examples.htm}>.
}
\details{
This function is a wrapper for multiple data request methods.  See code examples for which parameters are required for which methods.  Visit <\url{https://www.bls.gov/cew/opendata.htm}> for an overview of the BLS's open data access.
}
\examples{
## These examples are taken from the sample code examples found at: 
## <https://www.bls.gov/cew/doc/access/data_access_examples.htm>

## Area Data Request

## Required parameters are:
##  * year
##  * quarter
##  * area

## Example: Request the first quarter of 2013 for the state of Michigan
MichiganData <- blsQCEW('Area', year='2013', quarter='1', area='26000')
\dontrun{
## Industry Data Request

## Required parameters are:
##  * industry
##  * quarter
##  * year

## Example: Request Construction data for the first quarter of 2013
Construction <- blsQCEW('Industry', year='2013', quarter='1', industry='1012')

## Size Data Request
##  * size
##  * year

## Example: Request data for the first quarter of 2013 for establishments with 
## 100 to 249 employees
SizeData <- blsQCEW('Size', year='2013', size='6')
}
}
\keyword{bls}
\keyword{economics}
