% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_convex.R
\name{multivariateHingeLoss}
\alias{multivariateHingeLoss}
\title{The loss function for multivariate hinge loss}
\usage{
multivariateHingeLoss(x, y, loss.weights = 1)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{y}{logical matrix of targets: y(t,) is the vector of binary labels for x(t,)}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match nrow(x), but values are cycled if not of identical size.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
The loss function for multivariate hinge loss
}
\examples{
  x <- cbind(intercept=100,data.matrix(iris[1:4]))
  y <- model.matrix(~iris$Species+0)>0
  w <- nrbm(multivariateHingeLoss(x,y),LAMBDA=1)
  table(y,predict(w,x)>0,col(y))
  table(
    do.call(paste0,as.data.frame(y+0)),
    do.call(paste0,as.data.frame((predict(w,x)>0)+0))
  )
  
}
\seealso{
nrbm
}
