% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/anb-dag.R,
%   R/bnc-dag-operate.R
\name{inspect_bnc_dag}
\alias{inspect_bnc_dag}
\alias{class_var}
\alias{features}
\alias{vars}
\alias{families}
\alias{feature_families}
\alias{narcs}
\alias{is_semi_naive}
\alias{is_anb}
\alias{is_nb}
\alias{is_ode}
\title{Inspect a Bayesian network classifier structure.}
\usage{
class_var(x)

features(x)

vars(x)

families(x)

feature_families(x)

narcs(x)

is_semi_naive(x)

is_anb(x)

is_nb(x)

is_ode(x)
}
\arguments{
\item{x}{The \code{\link{bnc_dag}} object. The Bayesian network classifier
structure.}
}
\description{
Functions for inspecting a \code{\link{bnc_dag}} object.
}
\section{Functions}{
\itemize{
\item \code{class_var}: Returns the class variable.

\item \code{features}: Returns the features.

\item \code{vars}: Returns all variables (i.e., features + class).

\item \code{families}: Returns the family of each variable.

\item \code{feature_families}: Returns the family of each feature.

\item \code{narcs}: Returns the number of arcs.

\item \code{is_semi_naive}: Returns TRUE if \code{x} is a semi-naive Bayes.

\item \code{is_anb}: Returns TRUE if \code{x} is an augmented naive Bayes.

\item \code{is_nb}: Returns TRUE if \code{x} is a naive Bayes.

\item \code{is_ode}: Returns TRUE if \code{x} is a one-dependence estimator.
}}

\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
narcs(nb)
is_ode(nb)
}
