% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnc-dag-operate.R
\name{plot.bnc_dag}
\alias{plot.bnc_dag}
\title{Plot the structure.}
\usage{
\method{plot}{bnc_dag}(x, y, layoutType = "dot", fontsize = NULL, ...)
}
\arguments{
\item{x}{The \code{\link{bnc_dag}} object. The Bayesian network classifier
structure.}

\item{y}{Not used}

\item{layoutType}{a character. Optional.}

\item{fontsize}{integer Font size for node labels. Optional.}

\item{...}{Not used.}
}
\description{
If node labels are to small to be viewed properly, you may fix label fontsize
with argument fontsize. Also, you may try multiple different layouts.
}
\examples{
 

data(car)
nb <- nb('class', car)
nb <- nb('class', car)
plot(nb)
plot(nb, fontsize = 20)
plot(nb, layoutType = 'circo')
plot(nb, layoutType = 'fdp')
plot(nb, layoutType = 'osage')
plot(nb, layoutType = 'twopi')
plot(nb, layoutType = 'neato')
}
