% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setClasses.R
\name{setClasses}
\alias{setClasses}
\alias{importClasses}
\title{Set classes or intervals}
\usage{
setClasses(nodes, states, classBoundaries, wr = NULL, layer = NULL)

importClasses(classFile)
}
\arguments{
\item{nodes}{character. The nodes known and available as spatial data.}

\item{states}{A list of characters. The states associated to each of the nodes (order must match \code{nodes} names).}

\item{classBoundaries}{A list of numeric. The boundary values splitting the nodes into their corresponding states. They must be sorted in ascending order. For nominal categorical variables, \code{classBoundaries} must be the unique raster values associated to node states.}

\item{wr}{character. Optional, the full path to the file to be written. Default is set to NULL, otherwise it writes the formatted list returned by \code{setClasses} to the specified path. Suggested file format is .txt, albeit not mandatory.}

\item{layer}{character. Optional argument to indicate the path to files with input spatial data. If not NULL, then all nodes must have a corresponding file path, stored in the 'layer' element of output list.}

\item{classFile}{character. A text file where for each input variable associated to a node (see Details) three lines are specified as follows: 
the first one indicates the node name, as in the Bayesian network; the second indicates the states associated with such node, as they are in the Bayesian network (note that underscores are not allowed);
the third one contains the values associated to each state in the spatial data (for discrete variables) or the class boundaries dividing the states (for continuous variables), including minimum and maximum.}
}
\value{
A formatted list, specifying states break values for continuous nodes and integer values for categorical nodes.
}
\description{
Functions \code{setClasses} and \code{importClasses} return a formatted list from given arguments, to be used for the integration and error checking of Bayesian network and input spatial variables.
For \code{setClasses} a vector with node names and a list of vectors for both states of nodes and (optional) their boundaries in the spatial data 
must be provided, in the right order.
For \code{importClasses} a formatted text file must be provided (see Details).
}
\details{
As a reference for the text file format required by \code{importClasses}, for each node of the network:\cr
\strong{First line}: the node name.\cr
\strong{Second line}: the node states, comma separated (spaces allowed). NOTE: commas are NOT allowed inside the state names.\cr
\strong{Third line}: interval values from the spatial data associated to the states (integer values for discrete data; interval boundaries, including endpoints, for continuous data). The same exact order as node states is required.\cr

For example:

\code{CurrentLULC} \cr
\code{forest,other,arable} \cr
\code{2, 1, 3} \cr
\code{Slope} \cr
\code{flat, moderate, steep} \cr
\code{-Inf, 1, 7, Inf} \cr
\code{LegalStatus} \cr
\code{public, private, protected} \cr
\code{4, 3, 1 }

It is possible to write the formatted file automatically using \code{setClasses}, by setting argument \code{wr} as path to the text file to be created.
}
\examples{
## Load classes from external formatted text file
# Not run: importClasses('LUclasses.txt')
raw = system.file("extdata/LUclasses.txt", package = "bnspatial")
importClasses(raw)

## Same as:

setClasses(c('Slope', 'CurrentLULC', 'LegalStatus'), list(c('flat', 'moderate', 'steep'),
c('forest', 'arable', 'other'), c('public', 'private', 'protected')),
list(c(-Inf, 0, 5, Inf), c(2, 3, 1), (c(4, 3, 1))))

}
\seealso{
\code{\link{dataDiscretize}}
}
