% Generated by roxygen2 (4.0.0): do not edit by hand
\name{ensembleEstimators}
\alias{aggregatorArgs}
\alias{analyzePerformanceArgs}
\alias{ensembleEstimators}
\alias{estimationProcedureArgs}
\alias{estimatorPerformance}
\alias{extractAggregator}
\alias{extractAnalyzePerformance}
\alias{extractCalcBoostrPerformance}
\alias{extractData}
\alias{extractEstimationProcedure}
\alias{extractFormatData}
\alias{extractInitialWeights}
\alias{extractPerformanceOnLearningSet}
\alias{extractReweighter}
\alias{extractSubsetFormula}
\alias{oobVec}
\alias{reweighterArgs}
\alias{reweighterOutput}
\title{Extraction functions for boostr object attributes}
\usage{
ensembleEstimators(boostrObj)

reweighterOutput(boostrObj)

extractPerformanceOnLearningSet(boostrObj)

extractCalcBoostrPerformance(boostrObj)

estimatorPerformance(boostrObj)

oobVec(boostrObj)

extractReweighter(boostrObj)

reweighterArgs(boostrObj)

extractAggregator(boostrObj)

aggregatorArgs(boostrObj)

extractEstimationProcedure(boostrObj)

estimationProcedureArgs(boostrObj)

extractData(boostrObj)

extractAnalyzePerformance(boostrObj)

analyzePerformanceArgs(boostrObj)

extractSubsetFormula(boostrObj)

extractFormatData(boostrObj)

extractInitialWeights(boostrObj)
}
\arguments{
\item{boostrObj}{an object of class "\code{boostr}" -- most likely the output
of \code{\link{boost}} or \code{\link{boostBackend}}.}
}
\value{
The attribute referenced to in the function's title. E.g.,
\code{extractEstimationProcedure} returns the stored estimation procedure.
\code{ensembleEstimators} returns the ensemble of estimators built during
\code{\link{boostBackend}}.
}
\description{
Access the various attributes of "\code{boostr}" objects through
these functions. See \code{\link{boostBackend}} for a description of every
\code{boostr} attribute.
}

