% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistributionsToCIs.R
\name{getNegBinFromCI}
\alias{getNegBinFromCI}
\title{Find the best-fit negative binomial distribution for a given confidence interval.}
\usage{
getNegBinFromCI(
  qLow,
  qUpp,
  alpha = 0.05,
  initPars = c(10, 0.5),
  maxiter = 1000
)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 2 giving the initial parameter values (size & prob) to start the optimisation; defaults to c(10,0.5).}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A list with 5 elements:
\item{r}{The sampling function.}
\item{d}{The probability mass function.}
\item{p}{The distribution function.}
\item{q}{The quantile function.}
\item{pars}{A vector of length 2 giving the mean and standard deviation for the best-fit negatove binomial distribution (\code{size} and \code{prob} as in \code{\link{rnbinom}}, \code{\link{dnbinom}}, \code{\link{pnbinom}}, \code{\link{qnbinom}}).}
}
\description{
Finds the best-fit negative binomial distribution for a given confidence interval; returns the corresponding probability mass, distribution, quantile and sampling functions.
}
\examples{
n<-getNegBinFromCI(qLow=1.96,qUpp=19.12)
print(n$pars) # the fitted parameter values (size & prob)
n$r(10) # 10 random values from the fitted negative binomial distribution
n$d(8) # the probability mass at x=8 for the negative binomial distribution
n$p(12) # the cumulative probability at x=12 for the fitted negative binomial distribution
n$q(c(0.25,0.5,0.75)) # the 25th, 50th (median) and 75th percentiles of the fitted distribution
x<-0:30
y<-n$d(x)
barplot(height=y,names.arg=x,xlab="",ylab="probability mass") # bar plot of the fitted neg. bin. pmf

}
\seealso{
\code{\link{identifyNegBinPars}}, \code{\link{optim}}, \code{\link{dnbinom}}
}
