# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' calculate bootstrap inference
#'
#' @param ret refers to a returns matrix (columns = 2)
#' @param b blocksize to use. Choose the optimal blocksize by
#' \code{\link{blockSizeCalibrate}}
#' @param Delta_null refers to null hypothesis, where Delta means the difference
#' in sharpe ratio
#' @param M number of bootstrap resamples (see Eq. 9 in vignette)
#'
#' @return a list with estimated difference in sharpe ratio and p-value of the
#' test with \code{Delat_null} as null hypothesis
#'
#' @examples
#' \dontrun{
#' DATA <- bootTimeInference:::ret.hedge
#' opt <- blockSizeCalibrate(DATA, b_vec = c(1,2,4,6,8,10), K = 5000)
#' bootTimeInference(DATA, b = opt$b.optimal, M = 4999)
#' }
#' DATA <- bootTimeInference:::ret.hedge
#' # small example, please choose an appropiate K (see vignette)
#' opt <- blockSizeCalibrate(DATA, b_vec = c(1,2,4,6), K = 10)
#' bootTimeInference(DATA, b = opt$b.optimal, M = 4999)
#' @export
bootTimeInference <- function(ret, b, M, Delta_null = 0.0) {
    .Call('bootTimeInference_bootTimeInference', PACKAGE = 'bootTimeInference', ret, b, M, Delta_null)
}

#' calculate the optimal block size
#'
#' by Algorithm 3.1 in vignette on page 5
#'
#' @param ret refers to a returns matrix (columns = 2)
#' @param b_vec see vignette
#' @param alpha see vignette
#' @param M see vignette
#' @param K see vignette
#' @param b_av see vignette
#' @param T_start see vignette
#'
#' @return a list with probabilities and optimal block size
#'
#' @export
blockSizeCalibrate <- function(ret, b_vec = as.integer( c(1, 3, 6, 10)), alpha = 0.05, M = 199L, K = 1000L, b_av = 5L, T_start = 50L) {
    .Call('bootTimeInference_blockSizeCalibrate', PACKAGE = 'bootTimeInference', ret, b_vec, alpha, M, K, b_av, T_start)
}

