% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkstability.R
\name{network.stability}
\alias{network.stability}
\title{Estimate of detect module stability}
\usage{
network.stability(
  data.input,
  threshold,
  B = 20,
  cor.method,
  large.size,
  PermuNo,
  scheme_2 = FALSE
)
}
\arguments{
\item{data.input}{a \code{data.frame} of the data set where the rows are observations and columns are covariates}

\item{threshold}{a \code{numeric} number of threshold for correlation matrix}

\item{B}{number of bootstrap re-samplings}

\item{cor.method}{the correlation method applied to the data set,three method are available: \code{"pearson", "kendall", "spearman"}.}

\item{large.size}{the smallest set of modules, the \code{large.size=0} is recommended to use right now.}

\item{PermuNo}{number of random graphs for null}

\item{scheme_2}{\code{logical} \code{TRUE} if scheme 2 is used, \code{FASLE} if scheme 1 is used. 
Right now, only \code{FASLE} is recommended.}
}
\value{
\describe{
\item{\code{stabilityresult}}{a \code{list} of result for nodes-wise stability}
\item{\code{modularityresult}}{\code{list} of modularity information with the given threshold}
\item{\code{jaccardresult}}{\code{list} estimated unconditional observed stability and 
     the estimates of expected stability under the null}
\item{\code{originalinformation}}{\code{list} information for original data,
      igraph object and adjacency matrix constructed with the given threshold}
}
}
\description{
Estimate of detect module stability
}
\details{
This function estimates the modules' stability through bootstrapping 
approach for the given threshold. 
The approach to stability estimation is to compare the module composition of the reference correlation 
graph to the various bootstrapped correlation graphs, and to assess the stability at the 
(1) node-level, (2) module-level, and (3) overall.
}
\examples{
\dontrun{
set.seed(1)
data(wine)
x0 <- wine[1:50,]

mytest<-network.stability(data.input=x0,threshold=0.7, B=20, 
cor.method='pearson',large.size=0,
PermuNo = 10,
scheme_2 = FALSE)
}
}
\references{
A framework for stability-based module detection in correlation graphs.
Mingmei Tian,Rachael Hageman Blair,Lina Mu, Matthew Bonner, Richard Browne and Han Yu.
}
\author{
Mingmei Tian
}
