% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namespaced_function_calls.R
\name{namespaced_function_calls}
\alias{namespaced_function_calls}
\title{Check that \verb{namespace::function()} calls except for \verb{box::*()} are not made.}
\usage{
namespaced_function_calls(allow = NULL)
}
\arguments{
\item{allow}{Character vector of \code{namespace} or \verb{namespace::function} to allow in the source
code. Take not that the \verb{()} are not included. The \code{box} namespace will always be allowed}
}
\description{
Check that \verb{namespace::function()} calls except for \verb{box::*()} are not made.
}
\examples{
# will produce lints
code <- "box::use(package)
tidyr::pivot_longer()"

lintr::lint(text = code, linters = namespaced_function_calls())

## allow `tidyr::pivot_longer()`
code <- "box::use(package)
tidyr::pivot_longer()
tidyr::pivot_wider()"

lintr::lint(text = code, linters = namespaced_function_calls(allow = c("tidyr::pivot_longer")))

# okay
code <- "box::use(package)"

lintr::lint(text = code, linters = namespaced_function_calls())

## allow all `tidyr`
code <- "box::use(package)
tidyr::pivot_longer()
tidyr::pivot_wider()"

lintr::lint(text = code, linters = namespaced_function_calls(allow = c("tidyr")))

## allow `tidyr::pivot_longer()`
code <- "box::use(package)
tidyr::pivot_longer()"

lintr::lint(text = code, linters = namespaced_function_calls(allow = c("tidyr::pivot_longer")))

}
