% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bp_children}
\alias{bp_children}
\title{B-Proact1v Children Data}
\format{
A data frame containing 15 variables pertaining to blood pressure and physical
activity as follows:
\describe{

\item{id}{Child ID}
\item{reading}{Index of the blood pressure reading}
\item{sbp}{Systolic Blood Pressure (mmHg)}
\item{dbp}{Diastolic Blood Pressure (mmHg)}
\item{gender}{1 = Male\cr 2 = Female}
\item{hh_educ}{Household Highest Education:\cr\cr
1 = Up to GCSE/O level or equiv\cr
2 = A level/NVQ or equiv\cr
3 = Degree/HND or equiv\cr
4 = Higher degree (MSc/PhD) or equiv\cr}
\item{visit}{Visit #}
\item{age}{Age in Years}
\item{ht}{Height (ft)}
\item{wt}{Weight (lbs)}
\item{bmi}{Body Mass Index}
\item{N.valid.days.all}{Number of days of child accelerometer data overall}
\item{avg.mins.all}{Average minutes per day over all valid days}
\item{sed.avg.mins.all}{Average sedentary minutes per day over all valid days}
\item{mvpa.avg.mins.all}{Average minutes of Moderate to Vigorous Physical Activity (MVPA) per day over all valid days}

}
}
\source{
Original Paper: \doi{10.1371/journal.pone.0232333}

Data: \doi{10.5281/zenodo.1049587}

Principal Investigator (PI): Russ Jago (University of Bristol)
}
\usage{
bp_children
}
\description{
The \code{bp_children} data set contains information on 1,283 children from Bristol, UK,
who each took three blood pressure readings per visit over the course of two observation
periods (at ages 9 and 11) and had their body mass index (BMI), physical activity, and
sedentary time information recorded. The study examined how sedentary behavior and physical
activity affected children progressing through primary school to better understand the
relationship between elevated blood pressure in children and its impact on the development
of cardiovascular disease into adulthood
}
\details{
(Solomon-Moore E, Salway R, Emm-Collison L, Thompson JL, Sebire SJ, Lawlor DA, Jago R (PI). 2020).

Licensed under a CC-BY Creative Commons Attribution 4.0 International
}
\keyword{datasets}
