% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{generatePriorThetaY}
\alias{generatePriorThetaY}
\title{PriorThetaY list}
\usage{
generatePriorThetaY(m, n, p, muBar, hparam, qVec, ZOneDim, constraint)
}
\arguments{
\item{m}{the number of cluster}

\item{n}{sample size}

\item{p}{number of covariates}

\item{muBar}{parameter}

\item{hparam}{hyperparameters}

\item{qVec}{the vector of the number of factors in each clusters}

\item{ZOneDim}{ZOneDim}

\item{constraint}{constraint}
}
\value{
PriorThetaY list
}
\description{
generate prior value for parameter Theta and Y.
}
\examples{

sample_data = "https://raw.githubusercontent.com/lzyacht/bpgmm-examples/master/data/sampleData.csv"
X = utils::read.table(sample_data, header = TRUE, sep = ',')
X = as.matrix(X)
nsim = 1
burn = 20
n = ncol(X)
p = nrow(X)
m = 2
qVec = rep(3,m)
qnew = 3
delta = 2
ggamma = 2
dVec = c(1,1,1)
sVec = c(1,1,1)
constraint = c(1,1,1)
hparam = new("Hparam", alpha1=1, alpha2=2, bbeta=3, delta=4, ggamma=5)
muBar = apply(X, MARGIN = 1, FUN = mean)
ZOneDim = kmeans(x = t(X), centers = m)$cluster
generatePriorThetaY(m, n, p, muBar, hparam, qVec, ZOneDim, constraint)


}
