% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assign_lobes.R
\name{assign_lobes}
\alias{assign_lobes}
\title{Give vertices in a graph a \emph{lobe} attribute.}
\usage{
assign_lobes(g, atlas.dt, rand = FALSE)
}
\arguments{
\item{g}{An \emph{igraph} graph object.}

\item{atlas.dt}{A data table for a specific atlas.}

\item{rand}{A character string indicating whether this function is being run
for a random graph or a "graph of interest" (default: FALSE).}
}
\value{
An \emph{igraph} graph object with additional vertex attributes:
  \item{lobe}{Character string indicating the lobe}
  \item{lobe.hemi}{Integer vector indicating the lobe and hemisphere}
  \item{circle.layout}{Integer vector for ordering the vertices for circle
    plots}
}
\description{
This function will assign vertex attributes \emph{lobe} and \emph{lobe.hemi}
for all vertices in a graph, given a specific atlas. It will also add an
attribute \emph{circle.layout} for plotting circular graphs.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

