% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/group_graph_diffs.R
\name{group.graph.diffs}
\alias{group.graph.diffs}
\title{Do between-group tests at each vertex for a given graph measure}
\usage{
group.graph.diffs(g1, g2, measure, test = c("t.test", "wilcox.test", "lm"),
  covars = NULL, permute = FALSE, perm.order = NULL)
}
\arguments{
\item{g1}{A list of igraph graph objects for group 1}

\item{g2}{A list of igraph graph objects for group 2}

\item{measure}{A character string of the measure to test}

\item{test}{A character string for the test to use, either 't.test' (default)
or 'wilcox.test'}

\item{covars}{A data frame of covariates; only needed if using \emph{lm}
(default: NULL)}

\item{permute}{Logical; should be \emph{TRUE} if being called from
\code{\link{permute.vertex}} (default: FALSE)}

\item{perm.order}{A vector indicating the order that permuted subjects are
in; only necessary if being called from \code{\link{permute.vertex}}}
}
\value{
A graph with vertex attributes:
\item{size2}{equals the t-statistic}
\item{size}{\emph{size2} transformed to be positive values (for
visualization purposes)}
\item{p}{Equal to \eqn{1-p}}
\item{p.fdr}{Equal to \eqn{1-p_{FDR}} (the FDR-adjusted p-value)}
}
\description{
This function takes two lists of graphs (the length of each equaling the
number of subjects per group) and performs either a linear model, 2-sample
t-test, or 2-sample Wilcoxon test at each vertex for a given network measure
(e.g. vertex degree).
}
\details{
The linear model choice is currently pretty inflexible. You will need to
provide a data frame of covariates, of which \emph{Study.ID} and \emph{Group}
need to be column names. Additionally, all graphs must have a \emph{name}
attribute (at the graph level) which matches the \emph{Study.ID} for a given
subject. This function will then return the p-value, t-statistic, and
parameter estimate related to the \emph{Group} covariate.
}
\examples{
\dontrun{
g.diffs.btwn <- group.graph.diffs(g1, g2, 'btwn.cent', test='wilcox.test')
g.diffs.btwn <- group.graph.diffs(g.way[[1]][[5]], g.way[[2]][[5]], 'btwn.cent',
                                  test='lm', covars=covars.dti)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[stats]{t.test}, \link[stats]{wilcox.test},
\link[stats]{p.adjust}, \link{vec.transform}}
}

