% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness.R
\name{robustness}
\alias{robustness}
\title{Analysis of network robustness}
\usage{
robustness(g, type = c("vertex", "edge"), measure = c("btwn.cent", "degree",
  "random"), N = 1000)
}
\arguments{
\item{g}{The igraph graph object of interest}

\item{type}{A character string; either 'vertex' or 'edge' removals}

\item{measure}{A character string; sort by either 'btwn.cent' or 'degree', or
choose 'random'}

\item{N}{Integer; the number of iterations if \emph{random} is chosen}
}
\value{
A vector representing the ratio of maximal component size after each
removal to the graph's original maximal component
}
\description{
This function performs a "targeted attack" of a graph or a "random failure"
analysis, calculating the size of the largest component after edge or vertex
removal.
}
\details{
In a targeted attack, it will sort the vertices by either degree or
betweenness centrality (or sort edges by betweenness), and successively
remove the top vertices/edges. Then it calculates the size of the largest
component.

In a random failure analysis, vertices/edges are removed in a random order.
}
\references{
Albert R., Jeong H., Barabasi A. (2000) \emph{Error and attack
tolerance of complex networks}. Nature, 406:378-381.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
