% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_thresholds}
\alias{get_thresholds}
\title{Calculate the threshold values to result in a specific density}
\usage{
get_thresholds(mat, densities, emax = dim(mat)[1L] * (dim(mat)[1L] -
  1)/2, ...)
}
\arguments{
\item{mat}{Numeric matrix that will be thresholded}

\item{densities}{Numeric vector of densities}

\item{emax}{Integer; the maximum number of edges}

\item{...}{Arguments passed to \code{\link{sort}}}
}
\value{
Numeric vector of thresholds
}
\description{
Given a vector of densities, this function will return the numeric values
that will result in graphs of the given densities. It is assumed that the
density values are all between 0 and 1.
}
\keyword{internal}
