% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R, R/utils.R
\name{GLM helpers}
\alias{GLM helpers}
\alias{setup_glm}
\alias{contrast_names}
\alias{glm_fit_helper}
\alias{glm_data_table}
\alias{maxfun}
\alias{sortfun}
\title{Helper function to set-up for GLM analyses}
\usage{
setup_glm(covars, X, contrasts, con.type, con.name, measure, outcome,
  DT.y.m, level, ...)

contrast_names(contrasts, con.type, con.name, X)

glm_fit_helper(DT, X, con.type, contrasts, alt, outcome, mykey,
  alpha = NULL)

glm_data_table(g.list, level, measure)

maxfun(alternative)

sortfun(alternative)
}
\arguments{
\item{covars}{A \code{data.table} of covariates}

\item{X}{Numeric matrix, if you wish to supply your own design matrix}

\item{contrasts}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{con.name}{Character vector of the contrast name(s); if \code{contrasts}
has row names, those will be used for reporting results}

\item{measure}{Character string of the graph measure of interest}

\item{outcome}{Character string specifying the name of the outcome variable,
if it differs from the graph metric (\code{measure})}

\item{DT.y.m}{A \code{data.table} containing the outcome variable and
\code{Study.ID}}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}}

\item{DT}{A data.table with all the necessary data; namely \code{region}
(equals \code{graph} if \code{level='graph'}), and the outcome measure(s)}

\item{mykey}{The \code{key} to key by (to differentiate NBS and other GLM
analyses). For GLM, it is \code{'region'}; for NBS, it is
\code{'Var1,Var2'}.}

\item{alpha}{Numeric; the significance level. Default: 0.05}

\item{g.list}{A \code{brainGraphList} object}

\item{alternative}{Character string, whether to do a two- or one-sided test.
Default: \code{'two.sided'}}
}
\value{
\code{glm_data_table} - A \code{data.table} with one column
  containing the \code{Study.ID} and 1 or more columns with the graph- or
  vertex-level measure of interest.
}
\description{
\code{setup_glm} is used to setup the data/objects for any function that uses
the main GLM functionality in \code{brainGraph}.

Simple helper function to check the dimensions of contrasts, generate
contrast names, and set column names for GLM functions. For F-contrasts, if a
\code{matrix} is given, convert it to a \code{list} to simplify processing
later.

\code{glm_data_table} is used in \code{brainGraph_GLM} and
\code{brainGraph_mediate} to create a \code{data.table} with the
\code{Study.ID} and column(s) for the graph- or vertex-level metric of
interest.
}
\details{
This function: removes unused levels from \code{covars} and \code{DT.y.m},
removes subjects with incomplete data, creates a design matrix (if not
supplied), and supplies names to the contrast matrix.
}
\keyword{internal}
