% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_randomise.R
\name{setup_randomise}
\alias{setup_randomise}
\alias{randomise}
\title{Helper function to setup for randomise}
\usage{
setup_randomise(perm.method, part.method, X, contrasts, con.type, nC)

randomise(perm.method, part.method, N, perms, contrasts, con.type, nC,
  skip, DT, outcome, X, mykey)
}
\arguments{
\item{perm.method}{Character string indicating the permutation method.
Default: \code{'freedmanLane'}}

\item{part.method}{Character string; the method of partitioning the design
matrix into covariates of interest and nuisance. Default: \code{beckmann}}

\item{X}{Numeric matrix, if you wish to supply your own design matrix}

\item{contrasts}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{nC}{Integer; the number of contrasts}

\item{N}{Integer; number of permutations to create. Default: \code{5e3}}

\item{perms}{Matrix of permutations, if you would like to provide your own.
Default: \code{NULL}}

\item{skip}{Integer vector indicating which (if any) contrasts to skip (if
there were no significant differences anywhere)}

\item{DT}{\code{data.table} with outcome variables}

\item{outcome}{Character string specifying the name of the outcome variable,
if it differs from the graph metric (\code{measure})}

\item{mykey}{The \code{key} to key by (to differentiate NBS and other GLM
analyses). For GLM, it is \code{'region'}; for NBS, it is}
}
\value{
A list containing:
  \item{Mp}{The full partitioned model, joined}
  \item{Rz}{The residual-forming matrix}
  \item{MtM}{The inverse of the cross product of the full model}
  \item{eC}{The \emph{effective contrast}, equivalent to the original, for
    the partitioned model \code{[X, Z]} and considering all covariates}
  \item{dfR}{The residual degrees of freedom of the full partitioned model}
  \item{CMtM}{(only for F-contrasts) The effective contrast multiplied by the
    inverse of the cross-product of the full model.}
  \item{rkC}{(only for F-contrasts) Rank of the effective contrast matrix.}
  \item{Xp}{(only for Smith method) List of matrices of covariates of interest}
  \item{Zp}{(only for Smith method) List of matrices of nuisance covariates}

A \code{data.table} with \code{N} rows and columns specifying the
  region, permutation number, effect size (either \code{gamma} or the
  numerator for the \emph{F-statistic}), and standard error
}
\description{
\code{setup_randomise} is used to setup the data/objects for any function
that does permutations for GLM-based analysis.
}
\details{
The tasks performed by this function are:
\enumerate{
  \item Separate the design matrix into the independent variables of interest
    and nuisance variables (which is contrast-dependent) using
    \code{\link{partition}}.
  \item Calculate the new contrast(s) based on this new design matrix (also
    through \code{\link{partition}}
  \item Calculate the inverse of the cross produce of the full model
  \item Calculate the \dQuote{hat} and residual-forming matrices due to nuisance
    alone
  \item For F contrasts, return an inverse of the cross product between the
    contrast and the inverted design matrix, and the contrast's rank
}
}
\keyword{internal}
