% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_brainGraph_gui.R
\name{update_brainGraph_gui}
\alias{update_brainGraph_gui}
\title{Function to dynamically plot a graph}
\usage{
update_brainGraph_gui(plotDev, g, g2, plotFunc, vsize.measure,
  ewidth.measure, vertColor, hemi, lobe, orient, vertSize.min,
  edgeWidth.min, edgeWidth.max, vertSize.const, edgeWidth.const,
  vertLabels, showLegend, comms, neighb, neighbInd = NULL, slider,
  vertSize.other, edgeWidth.other, vertSize.eqn, showDiameter, edgeDiffs)
}
\arguments{
\item{plotDev}{A Cairo device for the plotting area}

\item{g}{An \code{igraph} graph object for the first plotting area}

\item{g2}{An \code{igraph} graph object for the second plotting area}

\item{plotFunc}{A character string specifying which type of plot to use}

\item{vsize.measure}{Character string of the name of the attribute for vertex
scaling}

\item{ewidth.measure}{Character string of the name of the attribute for edge
scaling}

\item{vertColor}{A GTK combo box for changing vertex colors}

\item{hemi}{A GTK combo box for plotting individual hemispheres}

\item{lobe}{Character string of the lobe name to select (comma-separated if
multiple lobes are listed)}

\item{orient}{A GTK combo box for plotting a specific orientation}

\item{vertSize.min}{A GTK spin button for minimum vertex size}

\item{edgeWidth.min}{A GTK spin button for minimum edge width}

\item{edgeWidth.max}{A GTK spin button for maximum edge width}

\item{vertSize.const}{A GTK entry for constant vertex size}

\item{edgeWidth.const}{A GTK entry for constant width}

\item{vertLabels}{A GTK check button for showing vertex labels}

\item{showLegend}{A GTK check button for showing a legend}

\item{comms}{Integer vector of the communities to plot}

\item{neighb}{Character vector of vertex names for getting neighborhoods}

\item{neighbInd}{Integer vector of vertex indices of \code{neighb}}

\item{slider}{A GTK horizontal slider widget for changing edge curvature}

\item{vertSize.other}{A GTK entry for vertex size (other attributes)}

\item{edgeWidth.other}{A GTK entry for edge width (other attributes)}

\item{vertSize.eqn}{A GTK entry for equations to exclude vertices}

\item{showDiameter}{A GTK check button for showing the graph's diameter}

\item{edgeDiffs}{A GTK check button for showing edge diffs between graphs}
}
\description{
This function is called by \link{plot_brainGraph_gui} to update the GUI.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\keyword{internal}
