\name{CE.Normal}
\alias{CE.Normal}
\title{
Multiple Break-point Detection via the CE Method for Continuous Data
}
\description{
This function performs calculations to estimate both the number of break-points and their corresponding locations of continuous measurements with the CE method. The normal distribution is used to model the observed continuous data. This function supports the simulation of break-point locations based on the four parameter beta distribution and truncated normal distribution. The modified BIC proposed by Zhang and Siegmund (2007) is used to select the optimal number of break-points. 
}
\usage{
CE.Normal(data, Nmax = 10, eps = 0.01, rho = 0.05, M = 200, h = 5, a = 0.8,
b = 0.8, distyp = 1, parallel = FALSE)
}
\arguments{
  \item{data}{
data to be analysed. A single column array or a data frame.
}
  \item{Nmax}{
maximum number of break-points. Default value is 10. 
}
  \item{eps}{
the cut-off value for the stopping criterion in the CE method. Default value is 0.01.
}
  \item{rho}{
the fraction which is used to obtain the best performing set of sample solutions (i.e., elite sample). Default value is 0.05.
}
  \item{M}{
sample size to be used in simulating the locations of break-points. Default value is 200.
}
  \item{h}{
minimum aberration width. Default is 5.
}
  \item{a}{
a smoothing parameter value. It is used in the four parameter beta distribution to smooth both shape parameters. When simulating from the truncated normal distribution, this value is used to smooth the estimates of the mean values. Default is 0.8.
}
  \item{b}{
a smoothing parameter value. It is used in the truncated normal distribution to smooth the estimates of the standard deviation. Default is 0.8.
}
  \item{distyp}{
distributions to simulate break-point locations. Options: 1 = four parameter beta distribution, 2 = truncated normal distribution. Default is 1. 
}
  \item{parallel}{
A logical argument specifying if parallel computation should be carried-out (TRUE) or not (FALSE). By default it is set as `FALSE'. In Windows OS systems "snow" functionalities are used, whereas in Unix/Linux/MAC OSX "multicore" functionalities are used to carryout parallel computations with the maximum number of cores available.
}
}
\details{
The normal distribution is used to model the continuous data. A performance function score (mBIC) is calculated for each of the solutions generated by the statistical distribution (four parameter beta distribution or truncated normal distribution), which is used to simulate break-points from no break-point to the user provided maximum number of break-points. The solution that maximizes the mBIC with respect to the number of break-points is reported as the optimal solution. Finally, a list containing a vector of break-point locations and the number of break-points are given in the console. 
}
\value{
A list is returned with following items:
\item{No.BPs}{The number of break-points in the data that is estimated by the CE method}
\item{BP.Loc}{A vector of break-point locations.}
}
\references{
 Priyadarshana, W. J. R. M., Sofronov G. (2014) Multiple Break-Points Detection in array CGH Data via the Cross-Entropy Method, IEEE/ACM Transactions on Computational Biology and Bioinformatics, no. 1, pp. 1, PrePrints, doi:10.1109/TCBB.2014.2361639, ISSN: 1545-5963.

  Priyadarshana, W. J. R. M. and Sofronov, G. (2012) A Modified Cross- Entropy Method for Detecting Multiple Change-Points in DNA Count Data, In Proc. of the IEEE Conference on Evolutionary Computation (CEC), 1020-1027, DOI: 10.1109/CEC.2012.6256470.
    
  Rubinstein, R., and Kroese, D. (2004) The Cross-Entropy Method: A Unified Approach to Combinatorial Optimization, Monte-Carlo Simulation and Machine Learning. Springer-Verlag, New York.
  
  Zhang, N.R., and Siegmund, D.O. (2007) A modified Bayes information criterion with applications to the analysis of comparative genomic hybridization data. Biometrics, 63, 22-32.
}
\author{
Priyadarshana, W.J.R.M. <madawa.weerasinghe@mq.edu.au>
}

\seealso{
 \code{\link{profilePlot}} to obtain mean profile plot.
}
\examples{
data(ch1.GM03563)
\dontrun{
## CE with four parameter beta distribution ##
obj1 <- CE.Normal(ch1.GM03563, distyp = 1, parallel =TRUE)
profilePlot(obj1, ch1.GM03563)

## CE with truncated normal distribution ##
obj2 <- CE.Normal(ch1.GM03563, distyp = 2, parallel =TRUE)
profilePlot(obj2, ch1.GM03563)
}
}